/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners.capability;

import com.aetherteam.aether.event.hooks.CapabilityHooks;
import com.aetherteam.aetherfabric.events.EntityTickEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;

public class AetherPlayerListener {
    public static void listen() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> AetherPlayerListener.onPlayerLogin((class_1657)handler.method_32311()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> AetherPlayerListener.onPlayerLogout((class_1657)handler.method_32311()));
        EntityTickEvents.AFTER.register(AetherPlayerListener::onPlayerUpdate);
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> AetherPlayerListener.onPlayerClone((class_1657)newPlayer, !alive));
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> AetherPlayerListener.onPlayerChangeDimension((class_1657)player));
    }

    @Environment(value=EnvType.CLIENT)
    public static void listenClient() {
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> AetherPlayerListener.onPlayerJoinLevel(entity));
    }

    public static void onPlayerLogin(class_1657 player) {
        CapabilityHooks.AetherPlayerHooks.login(player);
    }

    public static void onPlayerLogout(class_1657 player) {
        CapabilityHooks.AetherPlayerHooks.logout(player);
    }

    public static void onPlayerJoinLevel(class_1297 entity) {
        CapabilityHooks.AetherPlayerHooks.joinLevel(entity);
    }

    public static void onPlayerUpdate(class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            CapabilityHooks.AetherPlayerHooks.update(livingEntity);
        }
    }

    public static void onPlayerClone(class_1657 player, boolean wasDeath) {
        CapabilityHooks.AetherPlayerHooks.clone(player, wasDeath);
    }

    public static void onPlayerChangeDimension(class_1657 player) {
        CapabilityHooks.AetherPlayerHooks.changeDimension(player);
    }
}

